% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseInteractions.R
\name{parseLoopsTang}
\alias{parseLoopsTang}
\title{Parse chromatin interactions from Tang et al. 2015 as \code{GInteractions}.}
\usage{
parseLoopsTang(inFile, ...)
}
\arguments{
\item{inFile}{input file with loops}

\item{...}{additional arguments, that will be passed to
\code{\link[GenomicRanges:GRanges-class]{GRanges}} functions.}
}
\value{
An \code{\link{GInteractions}} with loops from input file.
}
\description{
Reads pairwise ChIA-PET interaction from an input file.
}
\details{
It reads files with the following tab-delimited format:

\tabular{lllllll}{ chr12\tab 48160351\tab 48161634\tab  chr12\tab 48230665\tab
48232848\tab 27 \cr chr7\tab 77284664\tab 77285815\tab chr7\tab  77388242\tab
77388928\tab 7 \cr chr4\tab 128459961\tab 128460166\tab chr4\tab
128508304\tab 128509082\tab 4 \cr }

This file format was used for ChIA-PET interaction data by Tang et al. 2015
\url{http://dx.doi.org/10.1016/j.cell.2015.11.024}. The last column of input
file is added as annotation column with colname "score".
}
\examples{
exampleLoopTang2015File <- system.file("extdata",
   "ChIA-PET_GM12878_Tang2015.chr22_1-30000000.clusters.txt",
   package = "sevenC")

gi <- parseLoopsTang(exampleLoopTang2015File)

# read loops with custom seqinfo object:
customSeqInfo <- Seqinfo(seqnames = c("chr1", "chr22"),
   seqlengths = c(10^8, 10^8), isCircular = c(FALSE, FALSE),
   genome = "custom")
gi <- parseLoopsTang(exampleLoopTang2015File, seqinfo = customSeqInfo)


}
