% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseInteractions.R
\name{parseLoopsRao}
\alias{parseLoopsRao}
\title{Parse chromatin loops from Rao et al. 2014 as strict
\code{\link[InteractionSet:InteractionSet-class]{GInteractions}}.}
\usage{
parseLoopsRao(inFile, ...)
}
\arguments{
\item{inFile}{input file with loops}

\item{...}{additional arguments, that will be passed to
\code{\link[GenomicRanges:GRanges-class]{GRanges}} functions.}
}
\value{
\code{\link{GInteractions}} with loops from input file.
}
\description{
Parse chromatin loops from Rao et al. 2014 as strict
\code{\link[InteractionSet:InteractionSet-class]{GInteractions}}.
}
\examples{

# use example loop file
exampleLoopFile <- system.file("extdata",
  "GM12878_HiCCUPS.chr22_1-30000000.loop.txt", package = "sevenC")

# read loops form example file:
gi <- parseLoopsRao(exampleLoopFile)


# read loops with custom seqinfo object:
customSeqInfo <- Seqinfo(seqnames = c("chr1", "chr22"),
   seqlengths = c(10^8, 10^8), isCircular = c(FALSE, FALSE),
   genome = "custom")
gi <- parseLoopsRao(exampleLoopFile, seqinfo = customSeqInfo)

}
