% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{searchIDATprefixes}
\alias{searchIDATprefixes}
\title{Identify IDATs from a directory}
\usage{
searchIDATprefixes(dir.name, recursive = TRUE, use.basename = TRUE)
}
\arguments{
\item{dir.name}{the directory containing the IDAT files.}

\item{recursive}{search IDAT files recursively}

\item{use.basename}{basename of each IDAT path is used as sample name
This won't work in rare situation where there are duplicate IDAT files.}
}
\value{
the IDAT prefixes (a vector of character strings).
}
\description{
The input is the directory name as a string. The function identifies all
the IDAT files under the directory. The function returns a vector of such
IDAT prefixes under the directory.
}
\examples{
## only search what are directly under
IDATprefixes <- searchIDATprefixes(
    system.file("extdata", "", package = "sesameData"))

## search files recursively is by default
IDATprefixes <- searchIDATprefixes(
    system.file(package = "sesameData"), recursive=TRUE)
}
