% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deidentify.R
\name{deIdentify}
\alias{deIdentify}
\title{De-identify IDATs by removing SNP probes}
\usage{
deIdentify(path, out_path = NULL, snps = NULL, mft = NULL, randomize = FALSE)
}
\arguments{
\item{path}{input IDAT file}

\item{out_path}{output IDAT file}

\item{snps}{SNP definition, if not given, default to SNP probes}

\item{mft}{sesame-compatible manifest if non-standard}

\item{randomize}{whether to randomize the SNPs. if TRUE,
randomize the signal intensities. one can use set.seed to
reidentify the IDAT with the secret seed (see examples).
If FALSE, this sets all SNP intensities to zero.}
}
\value{
NULL, changes made to the IDAT files
}
\description{
Mask SNP probe intensity mean by zero.
}
\examples{

my_secret <- 13412084
set.seed(my_secret)
temp_out <- tempfile("test")
deIdentify(system.file(
    "extdata", "4207113116_A_Grn.idat", package = "sesameData"),
     temp_out, randomize = TRUE)
unlink(temp_out)
}
