% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{bisConversionControl}
\alias{bisConversionControl}
\title{Compute internal bisulfite conversion control}
\usage{
bisConversionControl(sdf, extR = NULL, extA = NULL, verbose = FALSE)
}
\arguments{
\item{sdf}{a SigDF}

\item{extR}{a vector of probe IDs for Infinium-I probes that extend to
converted A}

\item{extA}{a vector of probe IDs for Infinium-I probes that extend to
original A}

\item{verbose}{print more messages}
}
\value{
GCT score (the higher, the more incomplete conversion)
}
\description{
Compute GCT score for internal bisulfite conversion control. The function
takes a \code{SigSet} as input. The higher the GCT score, the more likely
the incomplete conversion.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
bisConversionControl(sdf)

## For more recent platforms like EPICv2, MSA:
## One need extR and extA of other arrays using the sesameAnno
\dontrun{
mft = sesameAnno_buildManifestGRanges(sprintf(
  "\%s/EPICv2/EPICv2.hg38.manifest.tsv.gz",
  "https://github.com/zhou-lab/InfiniumAnnotationV1/raw/main/Anno/"),
  columns="nextBase")
extR = names(mft)[!is.na(mft$nextBase) & mft$nextBase=="R"]
extA = names(mft)[!is.na(mft$nextBase) & mft$nextBase=="A"]
}

}
