% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{sesameQC_rankStats}
\alias{sesameQC_rankStats}
\title{This function compares the input sample with public data.
Only overlapping metrics will be compared.}
\usage{
sesameQC_rankStats(qc, publicQC = NULL, platform = "EPIC")
}
\arguments{
\item{qc}{a sesameQC object}

\item{publicQC}{public QC statistics, filtered from e.g.: EPIC.publicQC,
MM285.publicQC and Mammal40.publicQC}

\item{platform}{EPIC, MM285 or Mammal40, used when publicQC is not given}
}
\value{
a sesameQC
}
\description{
This function compares the input sample with public data.
Only overlapping metrics will be compared.
}
\examples{

sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sesameQC_rankStats(sesameQC_calcStats(sdf, "intensity"))

}
