% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue.R
\name{compareReference}
\alias{compareReference}
\title{Compare array data with references (e.g., tissue, cell types)}
\usage{
compareReference(
  ref,
  betas = NULL,
  stop.points = NULL,
  query_width = 0.3,
  show_sample_names = FALSE
)
}
\arguments{
\item{ref}{the reference beta values in SummarizedExperiment.
One can download them from the sesameData package. See examples.}

\item{betas}{matrix of betas for the target sample
This argument is optional. If not given, only the reference will be shown.}

\item{stop.points}{stop points for the color palette.
Default to blue, yellow.}

\item{query_width}{the width of the query beta value matrix}

\item{show_sample_names}{whether to show sample names (default: FALSE)}
}
\value{
grid object that contrast the target sample with
references.
}
\description{
Compare array data with references (e.g., tissue, cell types)
}
\examples{

sesameDataCache() # if not done yet
compareReference(sesameDataGet("MM285.tissueSignature"))
sesameDataGet_resetEnv()

}
