% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapIntervalSets.R
\name{ssvOverlapIntervalSets}
\alias{ssvOverlapIntervalSets}
\title{Intersect a list of GRanges to create a single GRanges object of
merged ranges including metadata describing overlaps per input GRanges}
\usage{
ssvOverlapIntervalSets(
  grs,
  ext = 0,
  use_first = FALSE,
  preserve_mcols = FALSE,
  ...
)
}
\arguments{
\item{grs}{A list of GRanges}

\item{ext}{An integer specifying how far to extend ranges before merging.
in effect, ranges withing 2*ext of one another will be joined during the
merge}

\item{use_first}{A logical.  If True, instead of merging all grs, only use
first and add metadata logicals for others.}

\item{preserve_mcols}{Controls carrying forward mcols metadata from input
list of GRanges. If TRUE, all mcols will be carried forward with the item
name appended. If a character vector, only those attributes will be carried
and all must be present in all GRanges. The default of FALSE will carry
nothing forward and only membership table will be generated.
\link{ssvAnnotateSubjectGRanges} is used internally.}

\item{...}{arguments passed to IRanges::findOverlaps, i.e. maxgap, minoverlap, type, select, invert.}
}
\value{
GRanges with metadata columns describing overlap of input grs.
}
\description{
Intersect a list of GRanges to create a single GRanges object of
merged ranges including metadata describing overlaps per input GRanges
}
\examples{
library(GenomicRanges)
a = GRanges("chr1", IRanges(1:7*10, 1:7*10))
b = GRanges("chr1", IRanges(5:10*10, 5:10*10))
ssvOverlapIntervalSets(list(a, b))
}
