% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_helpers.R
\name{safeBrew}
\alias{safeBrew}
\title{safeBrew}
\usage{
safeBrew(n, pal = "Dark2")
}
\arguments{
\item{n}{integer value of number of colors to make palette for. Alternatively
a character or factor, in which case palette will be generated for each
unique item or factor level repsectively.}

\item{pal}{palette recognized by RColorBrewer}
}
\value{
a character vector of hex coded colors of length n from the color
brewer palette pal. If n is supplied as character or factor, output will be
named accordingly.
}
\description{
Allows RColorBrew to handle n values less than 3 and greater than 8 without
warnings and return expected number of colors.
}
\details{
For convenience, instead of the number n requested, n may be a character or
factor vector and outputs will be appropriately named for use with
scale_color/fill_manual.

Additionally, accepts pal as "gg", "ggplot", or "ggplot2" to reproduce
default ggplot colors in the same way.
}
\examples{
plot(1:2, rep(0, 2),  col = safeBrew(2, "dark2"), pch = 16, cex = 6)
plot(1:12, rep(0, 12),  col = safeBrew(12, "set1"), pch = 16, cex = 6)
plot(1:12, rep(0, 12),  col = safeBrew(12, "set2"), pch = 16, cex = 6)
plot(1:12, rep(0, 12),  col = safeBrew(12, "set3"), pch = 16, cex = 6)
}
