% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_helpers.R
\name{ggellipse}
\alias{ggellipse}
\title{ggellipse}
\usage{
ggellipse(
  xcentres,
  ycentres,
  r,
  r2 = r,
  phi = rep(0, length(xcentres)),
  circle_colors = NULL,
  group_names = LETTERS[seq_along(xcentres)],
  line_alpha = 1,
  fill_alpha = 0.3,
  line_width = 2,
  n_points = 200
)
}
\arguments{
\item{xcentres}{numeric x-coord of centers of ellipses}

\item{ycentres}{numeric y-coord of centers of ellipses, must have same
length as xcentres}

\item{r}{numeric radius1 of ellipse, must have length of 1 or match length
of xcentres}

\item{r2}{numeric radius2 of ellipse, must have length of 1 or match length
of xcentres.  same as r by default.}

\item{phi}{numeric phi of ellipse, must have length of 1 or match length
of xcentres.  0 by default.}

\item{circle_colors}{character of rcolors or hex colors or NULL.  if
null safeBrew of Dark2 is used}

\item{group_names}{character/factor names of color/fill groups.  capital
letters by default.}

\item{line_alpha}{numeric value from 0 to 1. alpha of lines, 1 by default}

\item{fill_alpha}{numeric value from 0 to 1. alpha of fill, .3 by default.}

\item{line_width}{numeric > 0.  passed to size. 2 by default}

\item{n_points}{integer > 1.  number of points to approximate circle with.
200 by default}
}
\value{
a ggplot containing ellipses
}
\description{
returns a ggplot with ellipses drawn using specified parameters
used by ssvFeatureVenn and ssvFeatureEuler
}
\details{
uses eulerr's non-exported ellipse drawing coordinate function
}
\examples{
ggellipse(xcentres = c(1, 1, 2),
    ycentres = c(2, 1, 1),
    r = c(1, 2, 1))
ggellipse(xcentres = c(1, 1, 2),
    ycentres = c(2, 1, 1),
    r = c(1, 2, 1),
    fill_alpha = 0,
    group_names = paste("set", 1:3))
ggellipse(xcentres = c(1, 1, 2),
    ycentres = c(2, 1, 1),
    r = c(1, 2, 1),
    circle_colors = c("red", "orange", "yellow"),
    line_alpha = 0,
    group_names = paste("set", 1:3))
}
