% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_easyLoad.R
\name{easyLoad_IDRmerged}
\alias{easyLoad_IDRmerged}
\title{easyLoad_IDRmerged loads "overlapped-peaks.txt" from IDR.}
\usage{
easyLoad_IDRmerged(
  file_paths,
  file_names = NULL,
  n_cores = getOption("mc.cores", 1),
  max_idr = 0.05
)
}
\arguments{
\item{file_paths}{character vector of paths to narrowPeak files.  If named,
those names will be used in output unless overriden by providing file_names.}

\item{file_names}{character vector of names for output list.  If not NULL
will override any existing names for file_paths.  Default is NULL.}

\item{n_cores}{number of cores to use, uses mc.cores option if set or 1.}

\item{max_idr}{maximum IDR value allowed}
}
\value{
named list of GRanges
}
\description{
easyLoad_IDRmerged loads "overlapped-peaks.txt" from IDR.
}
\examples{
idr_file = system.file("extdata/test_idr.overlapped-peaks.txt",
    package = "seqsetvis", mustWork = TRUE)
easyLoad_IDRmerged(idr_file)
easyLoad_IDRmerged(idr_file, max_idr = .01)
}
