% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_exon_signal.R
\name{collapse_gr}
\alias{collapse_gr}
\title{collapse_gr}
\usage{
collapse_gr(genome_gr)
}
\arguments{
\item{genome_gr}{a GRanges of regions on a single chromosome.  Regions
are intended to be non-contiguous and may even overlap.}
}
\value{
a new GRanges object with same mcols as input with all intervals
starting at 1 and no empty space between syntenic regions.
}
\description{
collapse non-contiguous regions (i.e. exons) into a contiguous coordinate
starting at 1.  this is strand sensitive and intended for use with
all exons of a single gene.
}
\examples{
library(data.table)
library(GenomicRanges)
dev_dat = data.table(seqnames = "chrTest",
                     transcript_id = c(1, 1,  2, 2, 3, 3, 3),
                     start = c(5,  30,  8, 30, 2, 30, 40),
                     end = c(10, 35, 15, 38, 7, 35, 45),
                     strand = "+")

genome_gr = GRanges(dev_dat)
collapse_gr(genome_gr)

neg_gr = genome_gr
strand(neg_gr) = "-"
collapse_gr(neg_gr)
}
