/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class HuffmanByteHelper {
    TreeMap<Integer, HuffmanBitCode> codes;
    private final int[] values;
    private final int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codeBook;
    private final HuffmanBitCode[] sortedCodes;
    private final int[] sortedValuesByBitCode;
    private final int[] sortedBitLensByBitCode;
    private final int[] bitCodeToValue;
    private final HuffmanBitCode[] valueToCode;
    private static final Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            int result = o1.bitLength - o2.bitLength;
            if (result == 0) {
                return o1.bitCode - o2.bitCode;
            }
            return result;
        }
    };

    HuffmanByteHelper(byte[] values, int[] bitLengths) {
        int i;
        this.values = new int[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.values[i2] = 0xFF & values[i2];
        }
        this.bitLengths = bitLengths;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> list = new ArrayList<HuffmanBitCode>(this.codes.size());
        list.addAll(this.codes.values());
        Collections.sort(list, bitCodeComparator);
        this.sortedCodes = list.toArray(new HuffmanBitCode[list.size()]);
        byte[] sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(sortedValues);
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int maxBitCode = 0;
        for (i = 0; i < this.sortedCodes.length; ++i) {
            this.sortedValuesByBitCode[i] = this.sortedCodes[i].value;
            this.sortedBitLensByBitCode[i] = this.sortedCodes[i].bitLength;
            if (maxBitCode >= this.sortedCodes[i].bitCode) continue;
            maxBitCode = this.sortedCodes[i].bitCode;
        }
        this.bitCodeToValue = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (i = 0; i < this.sortedCodes.length; ++i) {
            this.bitCodeToValue[this.sortedCodes[i].bitCode] = i;
        }
        this.valueToCode = new HuffmanBitCode[255];
        Arrays.fill(this.valueToCode, null);
        HuffmanBitCode[] arr$ = this.sortedCodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HuffmanBitCode code;
            this.valueToCode[code.value] = code = arr$[i$];
        }
    }

    private void buildCodeBook() {
        this.codeBook = new TreeMap();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.codeBook.containsKey(this.bitLengths[i])) {
                this.codeBook.get(this.bitLengths[i]).add(this.values[i]);
                continue;
            }
            TreeSet<Integer> entry = new TreeSet<Integer>();
            entry.add(this.values[i]);
            this.codeBook.put(this.bitLengths[i], entry);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        int codeLength = 0;
        int codeValue = -1;
        for (Integer key : this.codeBook.keySet()) {
            SortedSet<Integer> get = this.codeBook.get(key);
            int intKey = Integer.parseInt(((Object)key).toString());
            for (Integer entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLength = intKey;
                code.value = entry;
                ++codeValue;
                int delta = intKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (HuffmanByteHelper.NumberOfSetBits(codeValue) > intKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(entry, code);
            }
        }
    }

    final long write(BitOutputStream bitOutputStream, byte value) throws IOException {
        HuffmanBitCode code = this.valueToCode[value];
        if (code.value != value) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", value, code.toString()));
        }
        bitOutputStream.write(code.bitCode, code.bitLength);
        return code.bitLength;
    }

    final byte read(BitInputStream bitInputStream) throws IOException {
        int prevLen = 0;
        int bits = 0;
        for (int i = 0; i < this.sortedCodes.length; ++i) {
            int length = this.sortedCodes[i].bitLength;
            bits <<= length - prevLen;
            prevLen = length;
            int index = this.bitCodeToValue[bits |= bitInputStream.readBits(length - prevLen)];
            if (index > -1 && this.sortedBitLensByBitCode[index] == length) {
                return (byte)(0xFF & this.sortedValuesByBitCode[index]);
            }
            for (int j = i; this.sortedCodes[j + 1].bitLength == length && j < this.sortedCodes.length; ++j) {
                ++i;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        return (i + (i >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

