% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModel-Utils.R
\name{addReducedDims}
\alias{addReducedDims}
\title{Add scplainer Component Analysis Results}
\usage{
addReducedDims(sce, x)
}
\arguments{
\item{sce}{An instance of class \link{SingleCellExperiment}.}

\item{x}{A \code{List} of \code{DataFrames} containing principal components.
This list is typically the \code{bySample} element produced by
\code{\link[=scpComponentAnalysis]{scpComponentAnalysis()}}.}
}
\value{
A \code{SingleCellExperiment} with updated \code{reducedDims}.
}
\description{
The function will add the component results computed
by \code{\link[=scpComponentAnalysis]{scpComponentAnalysis()}} to a \code{SingleCellExperiment}'s
\code{reducedDims} slot, to all using the many \code{scater} functions,
such as \code{\link[scater:plotReducedDim]{scater::plotReducedDim()}}, \code{\link[scater:plot_reddim]{scater::plotTSNE()}}, ...
}
\examples{

library("scater")
data("leduc_minimal")
pcs <- scpComponentAnalysis(
   leduc_minimal, method = "ASCA",
   effects = "SampleType")$bySample

reducedDims(leduc_minimal)
leduc_minimal <- addReducedDims(leduc_minimal, pcs)
reducedDims(leduc_minimal)
plotReducedDim(leduc_minimal, dimred = "ASCA_SampleType",
               colour_by = "SampleType")
leduc_minimal <- runTSNE(leduc_minimal, dimred = "ASCA_SampleType")
plotTSNE(leduc_minimal, colour_by = "SampleType")
}
\author{
Laurent Gatto and Christophe Vanderaa
}
