% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ziber.R
\name{estimate_ziber}
\alias{estimate_ziber}
\title{Parameter estimation of zero-inflated bernoulli model}
\usage{
estimate_ziber(
  x,
  fp_tresh = 0,
  gfeatM = NULL,
  bulk_model = FALSE,
  pos_controls = NULL,
  em_tol = 0.01,
  maxiter = 100,
  verbose = FALSE
)
}
\arguments{
\item{x}{matrix. An expression data matrix (genes in rows, cells in columns)}

\item{fp_tresh}{numeric. Threshold for calling a positive detection (D = 1).
Default 0.}

\item{gfeatM}{matrix. Numeric gene level determinants of drop-out (genes in 
rows, features in columns)}

\item{bulk_model}{logical. Use median log-expression of gene in detected 
fraction as sole gene-level feature. Default FALSE. Ignored if gfeatM is 
specified.}

\item{pos_controls}{logical. TRUE for all genes that are known to be 
expressed in all cells.}

\item{em_tol}{numeric. Convergence treshold on log-likelihood.}

\item{maxiter}{numeric. The maximum number of iterations. Default 100.}

\item{verbose}{logical. Whether or not to print the value of the likelihood 
at each iteration.}
}
\value{
a list with the following elements: \itemize{ \item{W}{ coefficients
  of sample-specific logistic drop-out model } \item{Alpha}{ intercept and 
  gene-level parameter matrix } \item{X}{ intercept } \item{Beta}{ 
  coefficient of gene-specific logistic expression model } 
  \item{fnr_character}{ the probability, per gene, of P(D=0|E=1)} 
  \item{p_nodrop}{ 1 - the probability P(drop|Y), useful as weights in 
  weighted PCA} \item{expected_state}{ the expected
  value E[Z] (1 = "on")} \item{loglik}{ the log-likelihood} 
  \item{convergence}{ 0 if the algorithm converged and 1 if maxiter was 
  reached} }
}
\description{
This function implements an expectation-maximization algorithm for a 
zero-inflated bernoulli model of transcript detection, modeling gene 
expression state (off of on) as a bernoulli draw on a gene-specific 
expression rate (Z in {0,1}). Detection conditioned on expression is a 
logistic function of gene-level features. The bernoulli model is modeled 
numerically by a logistic model with an intercept.
}
\examples{
mat <- matrix(rpois(1000, lambda = 3), ncol=10)
mat = mat * matrix(1-rbinom(1000, size = 1, prob = .01), ncol=10)
ziber_out = suppressWarnings(estimate_ziber(mat,
   bulk_model = TRUE,
   pos_controls = 1:10))

}
