% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot_interactive.R
\name{biplot_interactive}
\alias{biplot_interactive}
\title{Interactive biplot}
\usage{
biplot_interactive(x, ...)
}
\arguments{
\item{x}{a \code{\link{SconeExperiment}} object.}

\item{...}{passed to \code{\link{biplot_color}}.}
}
\value{
A \code{\link{SconeExperiment}} object representing
  selected methods.
}
\description{
This is a wrapper around \code{\link{biplot_color}}, creating a shiny gadget
to allow the user to select specific points in the graph.
}
\details{
Since this is based on the shiny gadget feature, it will not work
  in static documents, such as vignettes or markdown / knitr documents. See
  \code{biplot_color} for more details on the internals.
}
\examples{
mat <- matrix(rpois(1000, lambda = 5), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")
obj <- SconeExperiment(mat)
res <- scone(obj, scaling=list(none=identity,
   uq=UQ_FN, deseq=DESEQ_FN,  fq=FQT_FN),
evaluate=TRUE, k_ruv=0, k_qc=0, eval_kclust=2,
   bpparam = BiocParallel::SerialParam())
\dontrun{
biplot_interactive(res)
}

}
