% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{selectFeatures}
\alias{selectFeatures}
\alias{selectFeatures}
\alias{selectFeatures.SingleCellExperiment}
\alias{selectFeatures,SingleCellExperiment-method}
\alias{selectFeatures}
\title{Find the most informative features (genes/transcripts) for projection}
\usage{
selectFeatures(object, n_features = 500, suppress_plot = TRUE)

selectFeatures.SingleCellExperiment(object, n_features, suppress_plot)

\S4method{selectFeatures}{SingleCellExperiment}(object, n_features = 500,
  suppress_plot = TRUE)
}
\arguments{
\item{object}{an object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class}

\item{n_features}{number of the features to be selected}

\item{suppress_plot}{boolean parameter, which defines whether to plot 
log(expression) versus log(dropout) distribution for all genes.
Selected features are highlighted with the red colour.}
}
\value{
an object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class with a new column in 
\code{rowData(object)} slot which is called \code{scmap_features}. It can be accessed
by using \code{as.data.frame(rowData(object))$scmap_features}.
}
\description{
This is a modification of the M3Drop method. Instead of fitting a 
Michaelis-Menten model to the log expression-dropout relation, we fit a 
linear model. Namely, the linear model is build on the log(expression) versus 
log(dropout) distribution. After fitting a linear model important features are
 selected as the top N residuals of the linear model.
}
\details{
Please note that \code{feature_symbol} column of \code{rowData(object)} must be 
present in the input object and should not contain any duplicated feature names. 
This column defines feature names used during projection. Feature symbols 
in the reference dataset must correpond to the feature symbols
in the projection dataset, otherwise the mapping will not work!
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- selectFeatures(sce)

}
