% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igblast.R
\name{igblast}
\alias{igblast}
\title{Run IgBLAST python wrapper}
\usage{
igblast(database, fasta, threads = 1)
}
\arguments{
\item{database}{Vector containing the database for VDJ sequences}

\item{fasta}{Vector containing the sequences, usually a column from a data.frame. eg. df$sequences}

\item{threads}{Variable containing the number of cores when computing in parallel, default threads = 1}
}
\value{
Creates a data frame with the IgBLAST annotation where each row is the queried sequence with columns containing the IgBLAST results
}
\description{
A wrapper funtion to run the IgBLAST python script to annotate VDJ sequences.
It is python based and relies on conda environments that are built when the
funtion is called.
}
\examples{
## Example with test sequences
\dontrun{
igblast(
    database = system.file("/extdata/test_fasta/KIMDB_rm", package = "scifer"),
    fasta = system.file("/extdata/test_fasta/test_igblast.txt", package = "scifer"),
    threads = 1
)
}
}
