% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runUMAP.R
\name{runUMAP}
\alias{runUMAP}
\title{UMAP using uwot. Parameters are set to be similar to Seurat's}
\usage{
runUMAP(
  spe,
  n_neighbors = 30,
  n_components = 2,
  metric = "cosine",
  min_dist = 0.3,
  assay = NULL,
  dimred = "PCA",
  n_dimred = NULL,
  name = "UMAP",
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{n_neighbors, n_components, metric, min_dist}{See \link[uwot]{umap}}

\item{assay}{Name of assay for UMAP. Incompatible with dimred.}

\item{dimred}{Name of the dimensionality reduction (e.g. PCA) for UMAP. Incompatible with assay}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use if dimred is specified.}

\item{name}{Name to store the UMAP in the spe's \link[SingleCellExperiment]{reducedDims}.}

\item{...}{Other parameters to be passed to \link[uwot]{umap}.}
}
\value{
A SpatialExperiment with the UMAP stored in \link[SingleCellExperiment]{reducedDims}.
}
\description{
UMAP using uwot. Parameters are set to be similar to Seurat's
}
\details{
By default, runUMAP uses PCA (from \link[scider]{runPCA}). If that's
unavailable, it falls back to logcounts, then counts assay.
}
\examples{

data("xenium_bc_spe")
spe <- runPCA(spe)
spe <- runUMAP(spe,dimred="PCA",n_dimred=10)
}
