% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPCA.R
\name{runPCA}
\alias{runPCA}
\title{Fast PCA using irlba.}
\usage{
runPCA(
  spe,
  n_pcs = 50,
  assay = "logcounts",
  centre = TRUE,
  scale = TRUE,
  name = "PCA",
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{n_pcs}{Number of principal components to calculate}

\item{assay}{Name of assay used for PCA. See details for defaults.}

\item{centre}{Logical. Whether to centre the assay before PCA.}

\item{scale}{Logical. Whether to scale the variance to 1 before PCA.}

\item{name}{Name to store the PCA in the spe's \link[SingleCellExperiment]{reducedDims}}

\item{...}{Other parameters to be passed to \link[irlba]{irlba}.}
}
\value{
A SpatialExperiment with the PCA stored in \link[SingleCellExperiment]{reducedDims}.
}
\description{
Fast PCA using irlba.
}
\details{
By default, runPCA uses logcounts assay (from \link[scider]{normalizeAssay}).
If that's unavailable, it falls back to counts assay
}
\examples{

data("xenium_bc_spe")

spe <- runPCA(spe)
}
