% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNiche.R
\name{getNiche}
\alias{getNiche}
\title{Build a niche assay based on the profile of neighbouring cells}
\usage{
getNiche(
  spe,
  at = c("cell", "grid"),
  nbrs_name = NULL,
  group.by,
  use_weight = FALSE
)
}
\arguments{
\item{spe}{A SpatialExperiment object}

\item{at}{Option of cell or grid neighbourhood}

\item{nbrs_name}{Name of the neighbour list in \code{spe@metadata$grid[[at]]}}

\item{group.by}{Character vector to group neighbours cell by. Should be in
either colData(spe) or spe@metadata$grid_density, depending
on "at". Multiple groups can be used. See details}

\item{use_weight}{Whether to scale each nbr based on its weight}
}
\value{
A matrix where rows are cells/grid points and cols are groups based
on group.by
}
\description{
Build a niche assay based on the profile of neighbouring cells
}
\details{
For numerical group, result will be sum of nbrs for each cell. For
categorical group (factor/string), result will be counts of nbrs belonging in
category
}
\examples{

data("xenium_bc_spe")

spe <- findNbrsSpatial(spe,k=30)
niche = getNiche(spe,at="cell",group.by="cell_type")
}
