% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNbrsSNN.R
\name{findNbrsSNN}
\alias{findNbrsSNN}
\title{Construct a SNN neighbour list from assay.}
\usage{
findNbrsSNN(
  spe,
  assay = NULL,
  dimred = "PCA",
  n_dimred = 10,
  k = 20,
  BNPARAM = BiocNeighbors::AnnoyParam(),
  type = c("rank", "number", "jaccard"),
  nbrs_name = NULL,
  cpu_threads = 6
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{assay}{Name of assay for clustering. Incompatible with dimred.}

\item{dimred}{Name of the dimensionality reduction (e.g. PCA) for clustering.
Incompatible with assay}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use if dimred is specified.}

\item{k}{Integer scalar for number of nearest neighbors to find.}

\item{BNPARAM}{\link[BiocNeighbors]{BiocNeighborParam} object specifying the nearest neighbor algorithm. Default is Annoy.}

\item{type}{Type of weighting scheme for shared neighbors. Options are rank, number, and jaccard.
type="rank" is defined in Xu and Su (2015).}

\item{nbrs_name}{Name of the neighbour list to be stored in spe. Default to be
assay/dimred + "_snn".}

\item{cpu_threads}{Number of cpu threads for parallel computation.}
}
\value{
A spe with the clusters stored in \link[SingleCellExperiment]{reducedDims}.

A SpatialExperiment object
}
\description{
Construct a SNN neighbour list from assay.
}
\details{
Construct a SNN neighbour list using either the spe's assay or reduced
dimension and store it in spe@metadata$nbrs$cell

neighbour list contain
}
\examples{

data("xenium_bc_spe")
spe <- runPCA(spe)
spe <- findNbrsSNN(spe,dimred="PCA")
}
