% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.top.aspects}
\alias{pagoda.top.aspects}
\title{Score statistical significance of gene set and cluster overdispersion}
\usage{
pagoda.top.aspects(pwpca, clpca = NULL, n.cells = NULL,
  z.score = qnorm(0.05/2, lower.tail = FALSE), return.table = FALSE,
  return.genes = FALSE, plot = FALSE, adjust.scores = TRUE,
  score.alpha = 0.05, use.oe.scale = FALSE, effective.cells.start = NULL)
}
\arguments{
\item{pwpca}{output of pagoda.pathway.wPCA()}

\item{clpca}{output of pagoda.gene.clusters() (optional)}

\item{n.cells}{effective number of cells (if not provided, will be determined using pagoda.effective.cells())}

\item{z.score}{Z score to be used as a cutoff for statistically significant patterns (defaults to 0.05 P-value}

\item{return.table}{whether a text table showing}

\item{return.genes}{whether a set of genes driving significant aspects should be returned}

\item{plot}{whether to plot the cv/n vs. dataset size scatter showing significance models}

\item{adjust.scores}{whether the normalization of the aspect patterns should be based on the adjusted Z scores - qnorm(0.05/2, lower.tail = FALSE)}

\item{score.alpha}{significance level of the confidence interval for determining upper/lower bounds}

\item{use.oe.scale}{whether the variance of the returned aspect patterns should be normalized using observed/expected value instead of the default chi-squared derived variance corresponding to overdispersion Z score}

\item{effective.cells.start}{starting value for the pagoda.effective.cells() call}
}
\value{
if return.table = FALSE and return.genes = FALSE (default) returns a list structure containing the following items:
\itemize{
\item{xv} {a matrix of normalized aspect patterns (rows- significant aspects, columns- cells}
\item{xvw} { corresponding weight matrix }
\item{gw} { set of genes driving the significant aspects }
\item{df} { text table with the significance testing results }
}
}
\description{
Evaluates statistical significance of the gene set and cluster lambda1 values, returning
either a text table of Z scores, etc, a structure containing normalized values of significant
aspects, or a set of genes underlying the significant aspects.
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
tam <- pagoda.top.aspects(pwpca, return.table = TRUE, plot=FALSE, z.score=1.96)  # top aspects based on GO only
}

}

