% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bwpca}
\alias{bwpca}
\title{Determine principal components of a matrix using per-observation/per-variable weights}
\usage{
bwpca(mat, matw = NULL, npcs = 2, nstarts = 1, smooth = 0,
  em.tol = 1e-06, em.maxiter = 25, seed = 1, center = TRUE,
  n.shuffles = 0)
}
\arguments{
\item{mat}{matrix of variables (columns) and observations (rows)}

\item{matw}{corresponding weights}

\item{npcs}{number of principal components to extract}

\item{nstarts}{number of random starts to use}

\item{smooth}{smoothing span}

\item{em.tol}{desired EM algorithm tolerance}

\item{em.maxiter}{maximum number of EM iterations}

\item{seed}{random seed}

\item{center}{whether mat should be centered (weighted centering)}

\item{n.shuffles}{optional number of per-observation randomizations that should be performed in addition to the main calculations to determine the lambda1 (PC1 eigenvalue) magnitude under such randomizations (returned in $randvar)}
}
\value{
a list containing eigenvector matrix ($rotation), projections ($scores), variance (weighted) explained by each component ($var), total (weighted) variance of the dataset ($totalvar)
}
\description{
Implements a weighted PCA
}
\examples{
set.seed(0)
mat <- matrix( c(rnorm(5*10,mean=0,sd=1), rnorm(5*10,mean=5,sd=1)), 10, 10)  # random matrix
base.pca <- bwpca(mat)  # non-weighted pca, equal weights set automatically
matw <- matrix( c(rnorm(5*10,mean=0,sd=1), rnorm(5*10,mean=5,sd=1)), 10, 10)  # random weight matrix
matw <- abs(matw)/max(matw)
base.pca.weighted <- bwpca(mat, matw)  # weighted pca

}

