% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_method.R
\name{print.sccomp_tbl}
\alias{print.sccomp_tbl}
\title{Print method for sccomp objects}
\usage{
\method{print}{sccomp_tbl}(x, ...)
}
\arguments{
\item{x}{A sccomp object}

\item{...}{Additional arguments passed to print}
}
\value{
The printed object
}
\description{
Print method for sccomp objects.

The print method for sccomp objects provides a summary of the model specifications,
data dimensions, and convergence diagnostics.

The output is formatted to be easy to read and understand.
}
\examples{

# Note: Before running the example, ensure that the 'cmdstanr' package is installed:
# install.packages("cmdstanr", repos = c("https://stan-dev.r-universe.dev/", getOption("repos")))

\donttest{
if (instantiate::stan_cmdstan_exists()) {
  # Create a sccomp object
  data("counts_obj") 
  estimate <- sccomp_estimate(
    counts_obj,
    ~ type,
    ~1,
    "sample",
    "cell_group",
    "count",
    cores = 1
  )
  print(estimate)
}
}

}
