% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_scatterplot}
\alias{plot_scatterplot}
\title{Plot Scatterplot of Cell-group Proportion}
\usage{
plot_scatterplot(
  .data,
  data_proportion,
  factor_of_interest,
  .cell_group,
  .sample,
  significance_threshold = 0.05,
  my_theme
)
}
\arguments{
\item{.data}{Data frame containing the main data.}

\item{data_proportion}{Data frame containing proportions of cell groups.}

\item{factor_of_interest}{A factor indicating the biological condition of interest.}

\item{.cell_group}{The cell group to be analysed.}

\item{.sample}{The sample identifier.}

\item{significance_threshold}{Numeric value specifying the significance threshold for highlighting differences. Default is 0.025.}

\item{my_theme}{A ggplot2 theme object to be applied to the plot.}
}
\value{
A ggplot object representing the scatterplot.
}
\description{
This function creates a scatterplot of cell-group proportions, optionally highlighting significant differences based on a given significance threshold.
}
\examples{
# Example usage:
# plot_scatterplot(.data, data_proportion, "condition", "cell_group", "sample", 0.025, theme_minimal())
}
