% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanning.R
\name{removeOverlappingRanges}
\alias{removeOverlappingRanges}
\title{removeOverlappingRanges}
\usage{
removeOverlappingRanges(
  x,
  minDist = 7L,
  retIndices = FALSE,
  ignore.strand = FALSE
)
}
\arguments{
\item{x}{A GRanges, sorted by (decreasing) importance.}

\item{minDist}{Minimum distance between ranges.}

\item{retIndices}{Logical; whether to return the indices of entries to
remove, rather than the filtered GRanges.}

\item{ignore.strand}{Logical. Whether the strand of the input ranges should
be ignored or not.}
}
\value{
A filtered GRanges, or an integer vector of indices to be removed if
`retIndices==TRUE`.
}
\description{
Removes elements from a GRanges that overlap (or are within a given distance
of) other elements higher up in the list (i.e. assumes that the ranges are
sorted in order of priority). The function handles overlaps between more than
two ranges by successively removing those that overlap higher-priority ones.
}
\examples{
library(GenomicRanges)
gr <- GRanges(seqnames=rep("A",4), IRanges(start=c(10,25,45,35), width=6))
removeOverlappingRanges(gr, minDist=7)
}
