% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizTreeData-class.R
\docType{class}
\name{EpivizTreeData-class}
\alias{EpivizTreeData-class}
\alias{EpivizTreeData}
\title{Data container for MRexperiment objects}
\description{
Used to serve hierarchical data (used in e.g., icicle plots and heatmaps).
}
\section{Methods}{

\describe{
\item{\code{df_to_tree(root, df)}}{Helper function to recursively build nested response for getHierarchy
\describe{
\item{root}{Root of subtree}
\item{df}{data.frame containing children to process}
}}

\item{\code{get_default_chart_type()}}{Get name of default chart type for this data type}

\item{\code{get_measurements()}}{Get description of measurements served by this object}

\item{\code{getCombined(
  measurements = NULL,
  seqName,
  start = 1,
  end = 1000,
  order = NULL,
  nodeSelection = NULL,
  selectedLevels = NULL
)}}{Return the counts aggregated to selected nodes for the given samples
\describe{
\item{measurements}{Samples to get counts for}
\item{seqName}{name of datasource}
\item{start}{Start of feature range to query}
\item{end}{End of feature range to query}
\item{order}{Ordering of nodes}
\item{nodeSelection}{Node-id and selectionType pairs}
\item{selectedLevels}{Current aggregation level}
}}

\item{\code{getHierarchy(nodeId = NULL)}}{Retrieve feature hierarchy information for subtree with specified root
\describe{
\item{nodeId}{Feature identifier with level info}
}}

\item{\code{getReducedDim(method = NULL, gene = NULL)}}{Compute PCA over all features for given samples
\describe{
\item{method}{which dimension to access}
\item{gene}{send expression of a gene back with the dimensions}
}}

\item{\code{getRows(
  measurements = NULL,
  start = 1,
  end = 1000,
  selectedLevels = 3,
  selections = NULL
)}}{Return the sample annotation and features within the specified range and level for a given sample and features
\describe{
\item{measurements}{Samples to retrieve for}
\item{start}{Start of feature range to query}
\item{end}{End of feature range to query}
\item{selections}{Node-id and selectionType pairs}
\item{selectedLevels}{Current aggregation level}
}}

\item{\code{propagateHierarchyChanges(
  selection = NULL,
  order = NULL,
  selectedLevels = NULL,
  request_with_labels = FALSE
)}}{Update internal state for hierarchy
\describe{
\item{selection}{Node-id and selectionType pairs}
\item{order}{Ordering of features}
\item{selectedLevels}{Current aggregation level}
\item{request_with_labels}{For handling requests using fData entries from MRexperiment}
}}

\item{\code{row_to_dict(row)}}{Helper function to format each node entry for getHierarchy response
\describe{
\item{row}{Information for current node.}
}}

\item{\code{searchTaxonomy(query = NULL, max_results = 15)}}{Return list of features matching a text-based query
\describe{
\item{query}{String of feature for which to search}
\item{max_results}{Maximum results to return}
}}
}}

