% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_model.R
\name{gof_model}
\alias{gof_model}
\title{gof_model}
\usage{
gof_model(lbic, cexpr, lib.size, formula = NULL, BPPARAM)
}
\arguments{
\item{lbic}{A list of genes together with filtered read counts based on the selected
distribution from \code{best_model}. Output from \code{best_model}.}

\item{cexpr}{A dataframe that contains the covariate values.
The rows of the dataframe are the corresponding samples/cells from the counts
matrix from \code{filter_counts}.
The cells of the dataframe are the covariates to be included in the GLM.}

\item{lib.size}{A numeric vector that contains the total number of counts
per cell from the counts matrix from \code{filter_counts}.}

\item{formula}{A regression formula to fit the covariates in the ZINB GLM.}

\item{BPPARAM}{configuration parameter related to the method of parallel execution.
For further information on how to set-up parallel execution refer to
\code{BiocParallel} vignette.}
}
\value{
A list of genes with the p-values from performing the GOF tests.
}
\description{
This function is used to perform the likelihood ratio test on the models chosen
based on the BIC values from \code{best_model} to check for model adequacy.
}
\examples{

data(scData)

# apply the gof_model function to perform the likelihood ratio
# test on the models selected by using the lbic_model function

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())
scData_bicvals <- model_bic(scData_models)
scData_least.bic <- lbic_model(scData_bicvals, scData$counts)

scData_gof <- gof_model(scData_least.bic, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())
}
