% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_counts.R
\name{filter_counts}
\alias{filter_counts}
\title{filter_counts}
\usage{
filter_counts(counts, perc.zero = 0.1)
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq raw read counts.
The rows of the matrix are genes and columns are samples/cells.}

\item{perc.zero}{A numeric value between 0 and 1 that represents the
proportion of zeros per gene in the processed dataset.}
}
\value{
An object of class \code{\link{Matrix}} with genes removed if
they have more than \code{perc.zero} zeros.
}
\description{
This function is used to preprocess matrix of read counts to
only keep genes with a certain number of nonzero entries.
}
\examples{

# load toy  example data

data(scData)

# apply the filter_counts function to filter out genes if they have
# more than 10\% zero

scData_filt <- filter_counts(scData$counts, perc.zero = 0.1)
}
