% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalRarefaction.R
\name{clonalRarefaction}
\alias{clonalRarefaction}
\title{Calculate rarefaction based on the abundance of clones}
\usage{
clonalRarefaction(
  input.data,
  cloneCall = "strict",
  chain = "both",
  group.by = NULL,
  plot.type = 1,
  hill.numbers = 0,
  n.boots = 20,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}}, or
\code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{plot.type}{sample-size-based rarefaction/extrapolation curve
(\code{type = 1}); sample completeness curve (\code{type = 2});
coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{hill.numbers}{The Hill numbers to be plotted out
(0 - species richness, 1 - Shannon, 2 - Simpson)}

\item{n.boots}{The number of bootstrap replicates used to derive confidence
intervals for the diversity estimates. More replicates can provide a more
reliable measure of statistical variability.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\description{
This functions uses the Hill numbers of order q: species richness (\code{q = 0}),
Shannon diversity (\code{q = 1}), the exponential of Shannon entropy and Simpson
diversity (\code{q = 2}, the inverse of Simpson concentration) to compute diversity
estimates for rarefaction and extrapolation. The function relies on the
\code{\link[iNEXT:iNEXT]{iNEXT::iNEXT()}} R package. Please read and cite the
\href{https://besjournals.onlinelibrary.wiley.com/doi/10.1111/2041-210X.12613}{manuscript}
if using this function. The input into the iNEXT calculation is abundance,
incidence-based calculations are not supported.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
                                    
# Using clonalRarefaction()
clonalRarefaction(combined[c(1,2)], cloneCall = "gene", n.boots = 3)


}
\concept{Visualizing_Clones}
