% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadContigs.R
\name{loadContigs}
\alias{loadContigs}
\title{Load Immune Receptor Sequencing Contigs}
\usage{
loadContigs(input, format = "10X")
}
\arguments{
\item{input}{A directory path containing contig files or a list/data frame
of pre-loaded contig data.}

\item{format}{A string specifying the data format. Must be one of:
\code{auto}, \verb{10X}, \code{AIRR}, \code{BD}, \code{Dandelion}, \code{JSON}, \code{MiXCR}, \code{ParseBio},
\code{TRUST4}, \code{WAT3R}, or \code{Immcantation}. If "auto", the function attempts
automatic format detection.}
}
\value{
A list of contigs formatted for use with \code{\link[=combineTCR]{combineTCR()}} or
\code{\link[=combineBCR]{combineBCR()}}. Rows containing only NA values (aside from the barcode)
are dropped.
}
\description{
This function loads and processes contig data from various single-cell
immune receptor sequencing formats. It reads data from a directory
(recursively) or from an already loaded list/data frame, transforms it to a
common structure, and returns a list of contigs ready for downstream analysis
with \code{\link[=combineTCR]{combineTCR()}} or \code{\link[=combineBCR]{combineBCR()}}.

Supported file formats and their expected file names:
\itemize{
\item \verb{10X}: "filtered_contig_annotations.csv"
\item \code{AIRR}: "airr_rearrangement.tsv"
\item \code{BD}: "Contigs_AIRR.tsv"
\item \code{Dandelion}: "all_contig_dandelion.tsv"
\item \code{Immcantation}: "_data.tsv" (or similar)
\item ``JSON`: ".json"
\item \code{ParseBio}: "barcode_report.tsv"
\item \code{MiXCR}: "clones.tsv"
\item \code{TRUST4}: "barcode_report.tsv"
\item \code{WAT3R}: "barcode_results.csv"
}
}
\examples{
TRUST4 <- read.csv("https://www.borch.dev/uploads/contigs/TRUST4_contigs.csv")
contig.list <- loadContigs(TRUST4, format = "TRUST4")

BD <- read.csv("https://www.borch.dev/uploads/contigs/BD_contigs.csv")
contig.list <- loadContigs(BD, format = "BD")

WAT3R <- read.csv("https://www.borch.dev/uploads/contigs/WAT3R_contigs.csv")
contig.list <- loadContigs(WAT3R, format = "WAT3R")

}
