% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalOverlap.R
\name{clonalOverlap}
\alias{clonalOverlap}
\title{Examining the clonal overlap between groups or samples}
\usage{
clonalOverlap(
  input.data,
  cloneCall = "strict",
  method = c("overlap", "morisita", "jaccard", "cosine", "raw"),
  chain = "both",
  group.by = NULL,
  order.by = NULL,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{method}{The method to calculate the \code{overlap}, \code{morisita},
\code{jaccard}, \code{cosine} indices or \code{raw} for the base numbers}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL}
(for both light chains), \code{both}.}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing clonal overlap or a data.frame if
\code{exportTable = TRUE}.
}
\description{
This functions allows for the calculation and visualizations of
various overlap metrics for clones. The methods include overlap
coefficient (\code{overlap}), Morisita's overlap index
(\code{morisita}), Jaccard index (\code{jaccard}), cosine
similarity (\code{cosine}) or the exact number of clonal
overlap (\code{raw}).
}
\details{
The formulas for the indices are as follows:

\strong{Overlap Coefficient:}
\deqn{overlap = \frac{\sum \min(a, b)}{\min(\sum a, \sum b)}}

\strong{Raw Count Overlap:}
\deqn{raw = \sum \min(a, b)}

\strong{Morisita Index:}
\deqn{morisita = \frac{\sum a b}{(\sum a)(\sum b)}}

\strong{Jaccard Index:}
\deqn{jaccard = \frac{\sum \min(a, b)}{\sum a + \sum b - \sum \min(a, b)}}

\strong{Cosine Similarity:}
\deqn{cosine = \frac{\sum a b}{\sqrt{(\sum a^2)(\sum b^2)}}}

Where:
\itemize{
\item{\eqn{a} and \eqn{b} are the abundances of species \eqn{i} in groups A and B, respectively.}
}
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using clonalOverlap()
clonalOverlap(combined, 
              cloneCall = "aa", 
              method = "jaccard")

}
\concept{Visualizing_Clones}
