% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalLength.R
\name{clonalLength}
\alias{clonalLength}
\title{Plot the Distribution of Sequence Lengths}
\usage{
clonalLength(
  input.data,
  cloneCall = "aa",
  chain = "both",
  group.by = NULL,
  order.by = NULL,
  scale = FALSE,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{nt} (CDR3 nucleotide sequence) or \code{aa} (CDR3 amino acid sequence)}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL}
(for both light chains), \code{both}.}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{scale}{Converts the graphs into density plots in order to show
relative distributions.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing the distributions by length, or a data.frame if
\code{exportTable = TRUE}.
}
\description{
This function displays either the nucleotide \code{nt} or amino
acid \code{aa} sequence length. The sequence length visualized
can be selected using the chains parameter, either the combined clone
(both chains) or across all single chains. Visualization can either
be a histogram or if \code{scale} = TRUE, the output will
be a density plot. Multiple sequencing runs can be group together
using the group.by parameter.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
clonalLength(combined, cloneCall="aa", chain = "both")

}
\concept{Visualizing_Clones}
