#' @title GSE827795 subset data
#'
#' @description A SingleCellExperiment object containing a subset expression 
#' matrix of GSE827795. The data contains log2 transformed FPKM expression.
#' 
#' GSE87795 is a mouse fetal liver development data containing 1000 genes, 
#' 367 cells and 6 cell types. 
#' 
#' The original GSE87795 data and the study details can be found at this
#' [link](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE87795)
#'
#'
#' @name gse87795_subset_sce
#' @docType data
#'
"gse87795_subset_sce"



#' scReClassify: a package for  post hoc cell type classification of single-cell 
#' RNA-sequencing data.
#' 
#' @description A post hoc cell type classification tool to fine-tune cell type 
#' annotations generated by any cell type classification procedure with 
#' semi-supervised learning algorithm AdaSampling technique. 
#' 
#' The current version of scReClassify supports Support Vector Machine and 
#' Random Forest as a base classifier.
#'
#' @author 
#' **Maintainer**: 
#' 
#' * Taiyun Kim (ORCID:0000-0002-5028-836X)
#'     - Email: taiyun.kim91@gmail.com
#' 
#' Authors:
#' 
#' * Pengyi Yang (ORCID: 0000-0003-1098-3138)
#' 
#' 
#' @seealso 
#' 
#' Useful links:
#' * Vignette available at: https://sydneybiox.github.io/scdney/
#' 
#' @docType package
#' @name scReClassify
NULL

