% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_aligning.R
\name{sc_aligning}
\alias{sc_aligning}
\title{aligning the demultiplexed FASTQ reads using the Rsubread:align()}
\usage{
sc_aligning(
  R1,
  R2 = NULL,
  tech = "atac",
  index_path = NULL,
  ref = NULL,
  output_folder = NULL,
  output_file = NULL,
  input_format = "FASTQ",
  output_format = "BAM",
  type = "dna",
  nthreads = 1
)
}
\arguments{
\item{R1}{a mandatory character vector including names of files that include sequence reads to be aligned. For paired-end reads, this gives the list of files including first reads in each library. File format is FASTQ/FASTA by default.}

\item{R2}{a character vector, the second fastq file, which is required if the data is paired-end}

\item{tech}{a character string giving the sequencing technology. Possible value includes "atac" or "rna"}

\item{index_path}{character string specifying the path/basename of the index files, if the Rsubread genome build is available}

\item{ref}{a character string specifying the path to reference genome file (.fasta, .fa format)}

\item{output_folder}{a character string, the name of the output folder}

\item{output_file}{a character vector specifying names of output files. By default, names of output files are set as the file names provided in R1 added with an suffix string}

\item{input_format}{a string indicating the input format}

\item{output_format}{a string indicating the output format}

\item{type}{type of sequencing data (`RNA` or `DNA`)}

\item{nthreads}{numeric value giving the number of threads used for mapping.}
}
\value{
the file path of the output aligned BAM file
}
\description{
after we run the \code{sc_trim_barcode} or \code{sc_atac_trim_barcode} to demultiplex the fastq files, we are using this
function to align those fastq files to a known reference.
}
\examples{
\dontrun{
sc_aligning(index_path,
    tech = 'atac',
    R1,  
    R2, 
    nthreads  = 6) 
}
}
