% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{plot_demultiplex}
\alias{plot_demultiplex}
\title{plot_demultiplex}
\usage{
plot_demultiplex(sce)
}
\arguments{
\item{sce}{a \code{SingleCellExperiment} object}
}
\value{
a ggplot2 bar chart
}
\description{
Plot cell barcode demultiplexing result for the
 \code{SingleCellExperiment}. The barcode demultiplexing result is shown
 using a barplot, with the bars indicating proportions of total reads.
 Barcode matches and mismatches are summarised along with whether or not the
 read mapped to the genome. High proportion of genome aligned reads with no
 barcode match may indicate barcode integration failure.
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

plot_demultiplex(sce)

}
