% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno_import.R
\name{anno_to_saf}
\alias{anno_to_saf}
\title{Convert annotation from GenomicRanges to Simple Annotation Format (SAF)}
\usage{
anno_to_saf(anno)
}
\arguments{
\item{anno}{The GRanges object containing exon information}
}
\value{
data.frame containing exon information in SAF format
}
\description{
This function converts a GRanges object into a data.frame of the
     SAF format for scPipe's consumption. The GRanges object should contain a
     "type" column where at least some features are annotated as "exon", in
     addition there should be a gene_id column specifying the gene to which the
     exon belongs. In the SAF only the gene ID, chromosome, start, end and
     strand are recorded, this is a gene-exon centric format, with all entries
     containing the same gene ID treated as exons of that gene. It is possible
     to count alternative features by setting the gene_id column to an arbitrary
     feature name and having alternative features in the SAF table, the main
     caveat is that the features are still treated as exons, and the mapping
     statistics for exon and intron will not reflect biological exons and
     introns but rather the annotation features.
}
\details{
Convert a GRanges object containing type and gene_id information into a SAF
format data.frame. SAF described at http://bioinf.wehi.edu.au/featureCounts/.
SAF contains positions for exons, strand and the GeneID they are associated
with.
}
\examples{
 \dontrun{
     anno <- system.file("extdata", "ensembl_hg38_chrY.gtf.gz", package = "scPipe")
     saf_chrY <- anno_to_saf(rtracklayer::import(anno))
 }

}
