% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkArgs.R
\name{checkArgs}
\alias{checkArgs}
\title{Check Arguments passed to the scPCA Function}
\usage{
checkArgs(
  target,
  background,
  center,
  scale,
  n_eigen,
  contrasts,
  penalties,
  clust_method,
  linkage_method,
  clusters,
  eigdecomp_tol,
  eigdecomp_iter,
  n_centers,
  scaled_matrix
)
}
\arguments{
\item{target}{The target (experimental) data set, in a standard format such
as a \code{data.frame} or \code{matrix}.}

\item{background}{The background data set, in a standard format such as a
\code{data.frame} or \code{matrix}.}

\item{center}{A \code{logical} indicating whether the target and background
data sets should be centered to mean zero.}

\item{scale}{A \code{logical} indicating whether the target and background
data sets should be scaled to unit variance.}

\item{n_eigen}{A \code{numeric} indicating the number of eigenvectors to be
computed.}

\item{contrasts}{A \code{numeric} vector of the contrastive parameters.}

\item{penalties}{A \code{numeric} vector of the penalty terms.}

\item{clust_method}{A \code{character} specifying the clustering method to
use for choosing the optimal constrastive parameter. Currently, this is
limited to either k-means, partitioning around medoids (PAM), and
hierarchical clustering. The default is k-means clustering.}

\item{linkage_method}{A \code{character} specifying the agglomerative
linkage method to be used if \code{clust_method = "hclust"}. The options
are \code{ward.D2}, \code{single}, \code{complete}, \code{average},
\code{mcquitty}, \code{median}, and \code{centroid}. The default is
\code{complete}.}

\item{clusters}{A \code{numeric} vector of cluster labels for observations in
the \code{target} data. Defaults to \code{NULL}, but is otherwise used to
identify the optimal set of hyperparameters when fitting the scPCA and the
automated version of cPCA.}

\item{eigdecomp_tol}{A \code{numeric} providing the level of precision used
by eigendecompositon calculations.}

\item{eigdecomp_iter}{A \code{numeric} indicating the maximum number of
interations performed by eigendecompositon calculations.}

\item{n_centers}{A \code{numeric} giving the number of centers to use in the
clustering algorithm. If set to 1, cPCA, as first proposed by
\insertCite{erichson2018sparse;textual}{scPCA}, is performed, regardless of
what the \code{penalties} argument is set to.}

\item{scaled_matrix}{A \code{logical} indicating whether to output a
\code{\link[ScaledMatrix]{ScaledMatrix}} object. The centering and scaling
procedure is delayed until later, permitting more efficient matrix
multiplication and row or column sums downstream. However, this comes at the
at the cost of numerical precision.}
}
\value{
Whether all argument conditions are satisfied
}
\description{
Checks whether or not the all arguments in the \code{scPCA}
  functions are input properly.
}
\references{
\insertAllCited{}
}
\keyword{internal}
