% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_benchmark.R
\name{plot_tsne}
\alias{plot_tsne}
\title{Plot t-SNE visualization of a data matrix}
\usage{
plot_tsne(
  data,
  labels,
  perplexity = 60,
  legend = "",
  plot.name = "",
  save = FALSE,
  rand.seed = 0,
  continuous = FALSE,
  labels2 = NULL,
  lim = NULL,
  runPCA = FALSE,
  alpha = 1
)
}
\arguments{
\item{data}{The \code{d}x\code{n} matrix}

\item{labels}{A vector of length \code{n}, usually cell clusters}

\item{perplexity}{Perplexity value used for t-SNE}

\item{legend}{A list of colors for the labels}

\item{plot.name}{The plot title}

\item{save}{If \code{TRUE}, save as \code{plot.name}.pdf}

\item{rand.seed}{The random seed}

\item{continuous}{Whether \code{labels} should be treated as continuous, e.g. pseudotime}

\item{labels2}{Additional label}

\item{lim}{Specify the xlim and y lim c(x_min, x_max, y_min, y_max)}

\item{runPCA}{Whether to run PCA before t-SNE}

\item{alpha}{The alpha value for the points}
}
\value{
the figure if not \code{save}, otherwise save the figure as \code{plot.name}.pdf
}
\description{
Plot t-SNE visualization of a data matrix
}
\examples{
results <- sim_example(ncells = 10)
plot_tsne(log2(results$counts + 1), results$cell_meta$pop, perplexity = 3)
}
