% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sce_cbind.R
\name{sce_cbind}
\alias{sce_cbind}
\title{Combind several \code{SingleCellExperiment} objects from different batches/experiments}
\usage{
sce_cbind(
  sce_list,
  method = "intersect",
  cut_off_batch = 0.01,
  cut_off_overall = 0.01,
  exprs = c("counts", "logcounts"),
  colData_names = NULL,
  batch_names = NULL
)
}
\arguments{
\item{sce_list}{A list contains the \code{SingleCellExperiment} Object from each batch}

\item{method}{A string indicates the method of combining the gene expression matrix,
either \code{union} or \code{intersect}. Default to \code{intersect}. \code{union} only supports matrix class.}

\item{cut_off_batch}{A numeric vector indicating the cut-off for the proportion of 
a gene is expressed within each batch}

\item{cut_off_overall}{A numeric vector  indicating the cut-off for the proportion of 
a gene is expressed overall data}

\item{exprs}{A string vector indicating the expression matrices to be combined. 
The first assay named will be used to determine the proportion of zeores.}

\item{colData_names}{A string vector indicating the \code{colData} that are combined}

\item{batch_names}{A string vector indicating the batch names for the output sce object}
}
\value{
A \code{SingleCellExperiment} object with the list of SCE objects combined.
}
\description{
Combind several \code{SingleCellExperiment} objects from 
different batches/experiments.
}
\examples{
data('example_sce', package = 'scMerge')
batch_names<-unique(example_sce$batch)
sce_list<-list(example_sce[,example_sce$batch=='batch2'],
               example_sce[,example_sce$batch=='batch3'])
sce_combine<-sce_cbind(sce_list,batch_names=batch_names)
}
\author{
Yingxin Lin
}
