% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regressPCObject.R
\name{plotRSquared}
\alias{plotRSquared}
\title{Generate R-squared Bar Plot with Component Breakdown}
\usage{
plotRSquared(x, ...)
}
\arguments{
\item{x}{An object of class \code{regressPCObject} containing regression results
from \code{regressPC} function.}

\item{...}{Additional arguments passed to the plotting function (currently unused).}
}
\value{
A \code{ggplot2} object representing the R-squared bar plot with optional
  component breakdown.
}
\description{
Creates a bar plot visualization of R-squared values for each principal component,
with optional stacked bars showing the contribution of individual model components
(cell type, batch/dataset, and interaction effects) when component decomposition
is available.
}
\details{
This function generates either a simple bar plot or a stacked bar plot depending
on the availability of component-wise R-squared decomposition in the input object.
When component breakdown is available, the bars are stacked to show:
\itemize{
  \item Cell type main effect (blue)
  \item Batch or dataset main effect (orange)
  \item Interaction effect (green)
}

Principal component labels include the percentage of total variance explained by
each PC. The total R-squared value is displayed above each bar. For query-only
analyses, the function uses query PCA variance; for query+reference analyses,
it uses reference PCA variance.
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
