% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_marginal.R
\name{fit_marginal}
\alias{fit_marginal}
\title{Fit the marginal models}
\usage{
fit_marginal(
  data,
  predictor = "gene",
  mu_formula,
  sigma_formula,
  family_use,
  n_cores,
  usebam = FALSE,
  edf_flexible = FALSE,
  parallelization = "mcmapply",
  BPPARAM = NULL,
  trace = FALSE,
  simplify = FALSE,
  filter_cells = FALSE
)
}
\arguments{
\item{data}{An object from \code{\link{construct_data}}.}

\item{predictor}{A string of the predictor for the gam/gamlss model. Default is "gene". This is just a name.}

\item{mu_formula}{A string of the mu parameter formula. It follows the format of formula in \code{\link[mgcv]{bam}}. Note: if the formula has multiple smoothers (\code{s()}) (we do not recommend this), please put the one with largest k (most complex one) as the first one.}

\item{sigma_formula}{A string of the sigma parameter formula}

\item{family_use}{A string or a vector of strings of the marginal distribution.
Must be one of 'binomial', 'poisson', 'nb', 'zip', 'zinb' or 'gaussian', which represent 'poisson distribution',
'negative binomial distribution', 'zero-inflated poisson distribution', 'zero-inflated negative binomial distribution',
and 'gaussian distribution' respectively.}

\item{n_cores}{An integer. The number of cores to use.}

\item{usebam}{A logic variable. If use \code{\link[mgcv]{bam}} for acceleration.}

\item{edf_flexible}{A logic variable. It uses simpler model to accelerate the marginal fitting with a mild loss of accuracy. If TRUE, the fitted regression model will use the fitted relationship between Gini coefficient and the effective degrees of freedom on a random selected gene sets. Default is FALSE.}

\item{parallelization}{A string indicating the specific parallelization function to use.
Must be one of 'mcmapply', 'bpmapply', or 'pbmcmapply', which corresponds to the parallelization function in the package
\code{parallel},\code{BiocParallel}, and \code{pbmcapply} respectively. The default value is 'mcmapply'.}

\item{BPPARAM}{A \code{MulticoreParam} object or NULL. When the parameter parallelization = 'mcmapply' or 'pbmcmapply',
this parameter must be NULL. When the parameter parallelization = 'bpmapply',  this parameter must be one of the
\code{MulticoreParam} object offered by the package 'BiocParallel. The default value is NULL.}

\item{trace}{A logic variable. If TRUE, the warning/error log and runtime for gam/gamlss will be returned.
will be returned, FALSE otherwise. Default is FALSE.}

\item{simplify}{A logic variable. If TRUE, the fitted regression model will only keep the essential contains for \code{predict}. Default is FALSE.}

\item{filter_cells}{A logic variable. If TRUE, when all covariates used for fitting the GAM/GAMLSS model are categorical, the code will check each unique combination of categories and remove cells in that category if it has all zero gene expression for each fitted gene.}
}
\value{
A list of fitted regression models. The length is equal to the total feature number.
}
\description{
\code{fit_marginal} fits the per-feature regression models.
}
\details{
The function takes the result from \code{\link{construct_data}} as the input,
and fit the regression models for each feature based on users' specification.
}
\examples{
  data(example_sce)
  my_data <- construct_data(
  sce = example_sce,
  assay_use = "counts",
  celltype = "cell_type",
  pseudotime = "pseudotime",
  spatial = NULL,
  other_covariates = NULL,
  corr_by = "1"
  )
  my_marginal <- fit_marginal(
  data = my_data,
  mu_formula = "s(pseudotime, bs = 'cr', k = 10)",
  sigma_formula = "1",
  family_use = "nb",
  n_cores = 1,
  usebam = FALSE
  )

}
