% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Perform diagnoisis of dispersion on the expression profile to check whether
scBFA works on specific dataset}
\usage{
diagnose(
  scData,
  sampleInfo = NULL,
  disperType = "Fitted",
  diagnose_feature = "dispersion"
)
}
\arguments{
\item{scData}{can be a raw count matrix,
in which rows are genes and columns are cells;
can be a seurat object; can be a SingleCellExperiment object.}

\item{sampleInfo}{sample level feature matrix,e.g batch effect,experimental conditions
in which rows are cells,columns are number of covariates.Default is NULL}

\item{disperType}{a parameter to tell which dispersion estimate the user can plot
DESeq2 offers stepwise dispersion estimate, a gene wise dispersion estimate using
"GeneEst", dispersion estimate from fitted disperions ~ mean curve (using "Fitted")
And final MAP estimate,using "Map". Default value is "Fitted"}

\item{diagnose_feature}{a parameter to determine whether the user want to check GDR or dispersion.}
}
\value{
A Figure to tell the where the input data's dispersion ~ tpm curve
align to the 14 benchmark datasets in Figure 2.a or Gene detection rate
}
\description{
Perform diagnoisis of dispersion on the expression profile to check whether
scBFA works on specific dataset
}
\examples{

data(exprdata)
diagnose(scData = exprdata)
}
\keyword{export}
