% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{locateClusters}
\alias{locateClusters}
\title{Locate occurrences of specified clusters of k-mers}
\usage{
locateClusters(clusters, seqs, directional = TRUE, showMatch = FALSE)
}
\arguments{
\item{clusters}{list of character vectors or XStringSet objects of
k-mers to search for}

\item{seqs}{character vector or XStringSet of sequences in which to
locate kmer}

\item{directional}{logical value: if FALSE, counts occurrences of
either k-mers within each cluster or their reverse-complements.
Makes sense only if applying to DNA sequences!}

\item{showMatch}{logical value; if true add additional column to
output indicating what the exact regex match for each
occurrence (can be slow)}
}
\value{
data.frame with three columns: `seqid' containing the name
    of the sequence from seqs in which the match was found;
    `cluster' indicating the cluster from wich a k-mer was located;
    and `location' giving the 1-based position at which the match
    was found.
}
\description{
Find locations of matches of list of character vectors of k-mers in
each element of a named character vector. Not case sensitive.
}
\examples{
seqs <- c(
    line1 = "My mind's got a mind of its own",
    line2 = "Takes me out to parties when I'd rather be alone",
    line3 = "Takes me out a-walkin' when I'd rather be at home"
)
clusters <- list(
    antisocial = c('alone', 'at home'),
    mind = 'mind'
)
clusterLoci <- locateClusters(clusters, seqs)

}
