% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodShared.R
\name{launchApp}
\alias{launchApp}
\title{Method launchApp}
\usage{
launchApp(object, outputDir = NULL, colors = "default")
}
\arguments{
\item{object}{A SangerContig or SangerAlignment S4 instance.}

\item{outputDir}{The output directory of the saved new SangerContig or SangerAlignment S4 instance.}

\item{colors}{A vector for users to set the colors of (A, T, C, G, else). 
There are three options for users to choose from. 
  1. "default":  (green, blue, black, red, purple). 
  2. "cb_friendly":  ((0, 0, 0), (199, 199, 199), (0, 114, 178), (213, 94, 0), (204, 121, 167)). 
  3. Users can set their own colors with a vector with five elements.}
}
\value{
A \code{SangerContig} or \code{SangerAlignment} object.
}
\description{
A method which launches Shiny application of the SangerContig
 and SangerAlignment instance.
}
\examples{
data(sangerContigData)
data(sangerAlignmentData)
\dontrun{
launchApp(sangerContigData)
launchApp(sangerContigData, colors="cb_friendly")
launchApp(sangerAlignmentData)
launchApp(sangerAlignmentData, colors="cb_friendly")}
}
\author{
Kuan-Hao Chao
}
