% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerRead.R
\name{SangerRead-class-writeFastaSR}
\alias{SangerRead-class-writeFastaSR}
\alias{writeFastaSR,SangerRead-method}
\title{writeFastaSR}
\usage{
\S4method{writeFastaSR}{SangerRead}(
  object,
  outputDir = NULL,
  compress = FALSE,
  compression_level = NA
)
}
\arguments{
\item{object}{A SangerRead S4 instance.}

\item{outputDir}{The output directory of the generated FASTA file.}

\item{compress}{Like for the \code{save} function in base R, must be \code{TRUE} or \code{FALSE} (the default), or a single string specifying whether writing to the file is to use compression. The only type of compression supported at the moment is "gzip". This parameter will be passed to \code{writeXStringSet} function in Biostrings package.}

\item{compression_level}{This parameter will be passed to \code{writeXStringSet} function in Biostrings package.}
}
\value{
The output absolute path to the FASTA file.
}
\description{
A SangerRead method which writes the sequence into Fasta files.
}
\examples{
data("sangerReadFData")
writeFastaSR(sangerReadFData)
}
