% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_types.R
\name{fileTypes}
\alias{fileTypes}
\alias{pxFileTypes}
\alias{updatePxFileTypes}
\title{Infer file type}
\usage{
fileTypes()

pxFileTypes(fls, types = fileTypes())

updatePxFileTypes(object, cache = rpxCache())
}
\arguments{
\item{fls}{\code{character()} of file names whose types need to be
inferred based on their file extenstion.}

\item{types}{\code{data.frame} of file types. Default is
\code{fileTypes()}.}

\item{object}{Object of class \code{PXDataset}.}

\item{cache}{Object of class \code{BiocFileCache}.}
}
\value{
A \code{data.frame} with the filenames and their inferred
types.
}
\description{
The \code{pxFileTypes()} function inferres mass spectrometry and
proteomics file types based on a currated table of file types and
associated patterns. This table can be accessed with
\code{fileTypes()}. See the examples below for the content and format
of the table.

The types of the files in a \code{PXDataset} object can be accessed
with the \code{pxfiles(as.vector = FALSE)} function. See examples in the
\code{\link[=pxfiles]{pxfiles()}} manual page.

\code{updatePxFileTypes()} updates the file types of a \code{PXDataset}
instance using \code{pxFileTypes()}. This function also udpates the
cached object unless \code{cache} is set to \code{NULL}. This function is
useful to harmonise file types when the data in \code{fileTypes()} is
updated.

The file types table is generated by \code{scripts/make_fileTypes.R}.
}
\examples{

fileTypes()

pxFileTypes("foo")
pxFileTypes("foo.mzML")
pxFileTypes("foo.raw")
pxFileTypes("foo.txt")
pxFileTypes("foo.R")
pxFileTypes("foo.fasta")

pxFileTypes(c("foo", "foo.mzML", "foo.R", "foo.fasta"))
}
\references{
\itemize{
\item McDonald, W. \emph{et al.} 2004. "MS1, MS2, and SQT-Three Unified, Compact,
and Easily Parsed File Formats for the Storage of Shotgun Proteomic
Spectra and Identifications." Rapid Communications in Mass Spectrometry
18 (18):2162–68.
\item Deutsch, Eric W. 2012. "File Formats Commonly Used in Mass Spectrometry
Proteomics." Molecular & Cellular Proteomics 11 (12):1612–21.
\item File formats in PRIDE Archive:
\url{https://www.ebi.ac.uk/pride/markdownpage/pridefileformats}.
}
}
\author{
Laurent Gatto with contributions via mastodon from
Dr. Samuel Wein, Michael MacCoss, Marc Vaudel, Phil Wilmarth
and Dave Tabb to identify several file types (see
\code{inst/make_file_types.R} for details).
}
