% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/plot-methods.R
\name{plot_score}
\alias{plot_score}
\alias{plot_score,SummarizedExperiment-method}
\alias{plot_score,opls-method}
\title{PCA and (O)PLS(-DA) score plots}
\usage{
plot_score(
  x,
  model.c = "",
  components.vi = c(1, 2),
  label.c = c("", "sample_names")[2],
  color.c = "",
  title.c = "",
  palette.c = "Set1",
  legend.c = "right",
  ellipse.l = TRUE,
  plotly.l = FALSE,
  info.vc = "sample_names",
  size.ls = list(axis_lab.i = 16, axis_text.i = 14, point.i = 3, label.i = 5, title.i =
    20, legend_title.i = 15, legend_text.i = 15)
)

\S4method{plot_score}{SummarizedExperiment}(
  x,
  model.c = "",
  components.vi = c(1, 2),
  label.c = c("", "sample_names")[2],
  color.c = "",
  title.c = "",
  palette.c = "Set1",
  legend.c = "right",
  ellipse.l = TRUE,
  plotly.l = FALSE,
  info.vc = "sample_names",
  size.ls = list(axis_lab.i = 16, axis_text.i = 14, point.i = 3, label.i = 5, title.i =
    20, legend_title.i = 15, legend_text.i = 15)
)

\S4method{plot_score}{opls}(
  x,
  model.c = "",
  components.vi = c(1, 2),
  label.c = c("", "sample_names")[2],
  color.c = "",
  title.c = "",
  palette.c = "Set1",
  legend.c = "right",
  ellipse.l = TRUE,
  plotly.l = FALSE,
  info.vc = "sample_names",
  size.ls = list(axis_lab.i = 16, axis_text.i = 14, point.i = 3, label.i = 5, title.i =
    20, legend_title.i = 15, legend_text.i = 15)
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment} (resp. \code{opls})
generated by the 'ropls::opls' modeling applied to a \code{SummarizedExperiment}
(resp. an \code{ExpressionSet})}

\item{model.c}{character(1): name of the model to be plotted; 
use 'names(ropls::getOpls(se))' to see the available models in the se object}

\item{components.vi}{integer(2): number of the components to display as x and y axis}

\item{label.c}{character(1): name of the colData (resp. pData) column 
to be used for the labels}

\item{color.c}{character(1): name of the colData (resp. pData) column 
to be used for the colors}

\item{title.c}{character(1): plot title}

\item{palette.c}{character(1): name of the RColorBrewer palette (for qualitative factor)}

\item{legend.c}{character(1): position of the legend (either 'bottom', 'left',
'top' or 'right' [default])}

\item{ellipse.l}{logical(1): should ellipses be drawn (for qualitative factor)}

\item{plotly.l}{logical(1): should the ggplot be converted to an interactive
plotly (default: FALSE)}

\item{info.vc}{character(): names of the colData (resp. pData) columns
to be used for the plotly info; the default 'sample_names' will return 
the sample names as the plotly info}

\item{size.ls}{list: sizes for axis labels (default: 16), axis text (default: 14),
points (default: 3), labels (default = 5), title (default = 20), legend title (default: 15),
legend text (default: 15)}
}
\value{
invisible ggplot2 (or ggplotly) object
}
\description{
Score plot visualization for PCA and (O)PLS(-DA) models in either ggplot or ggplotly formats
}
\examples{
# loading the 'sacurine' dataset from the 'ropls' package
data(sacurine, package = "ropls")
# SummarizedExperiment
sac.se <- sacurine[["se"]]
## computing the PCA
sac.se <- opls(sac.se)
## score plot
plot_score(sac.se, "PCA")
plot_score(sac.se, "PCA", color.c = "age")
plot_score(sac.se, "PCA", color.c = "gender", plotly.l = TRUE, info.vc = "all")
## PLS-DA modeling
sac.se <- opls(sac.se, "gender")
plot_score(sac.se, "gender_PLSDA")
plot_score(sac.se, "gender_PLSDA", plotly.l = TRUE)
## OPLS-DA modeling
sac.se <- opls(sac.se, "gender", predI = 1, orthoI = NA)
plot_score(sac.se, "gender_OPLSDA")
plot_score(sac.se, "gender_OPLSDA", plotly.l = TRUE, info.vc = "all")
# empty plot (in case no model was built)
rand.se <- sac.se
rand.se$gender <- sample(rand.se$gender)
rand.se <- opls(rand.se, "gender")
plot_score(rand.se, "gender_PLSDA")
# 1D plot (in case of a single predicted component)
single.se <- opls(sac.se, predI = 1, fig.pdfC = "none")
plot_score(single.se, "PCA", label.c = "")
single.se <- opls(sac.se, "gender", predI = 1, fig.pdfC = "none")
plot_score(single.se, "gender_PLSDA")
# ExpressionSet
sacurine.eset <- sacurine[["eset"]]
## PCA
sacurine.pca <- opls(sacurine.eset)
## score plot (model.c does not need to be specified here since 'opls' objects contain only one model)
plot_score(sacurine.pca)
plot_score(sacurine.pca, color.c = "age")
}
