% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{lowarp}
\alias{lowarp}
\title{A multi response optimization data set (LOWARP)}
\format{
A data frame with the following parameters:
\itemize{
\item num mixture number
\item glas glas constituent
\item crtp crtp constituent
\item mica mica constituent
\item amtp amtp constituent
\item wrp1 warp response 1
\item wrp2 warp response 2
\item wrp3 warp response 3
\item wrp4 warp response 4
\item wrp5 warp response 5
\item wrp6 warp response 6
\item wrp7 warp response 7
\item wrp8 warp response 8
\item st1 strength response 1
\item st2 strength response 2
\item st3 strength response 3
\item st4 strength response 4
\item st5 strength response 5
\item st6 strength response 6
}
}
\value{
Data frame (numeric type only; the first column can be transformed
into row names) with 17 rows and 19 columns corresponding to the subject's
'num'ber (column 1), the 4 constituent variables (columns 2-5), the 8 warp
responses (columns 6-13), and the 6 strength responses (columns 14-19). For
details see the 'Format' section above.
}
\description{
This example concerns the development of a polymer similar to that used in
the plastic covering of mobile phones. The desired profile of the polymer
was low warp and high strength. Four constituents (glas, crtp, mica, and
amtp) were varied in the polymer formulation by means of a 17 run mixture
design. For each new polymer, i.e., each new experiment in the mixture
design, 14 responses relating to both warp and strength were measured on the
product. The objective of the data analysis was to uncover which combination
of factors (the four ingredients) gave polymers with low warp and high
strength. The data set contains 10 missing values (NA).
}
\references{
Eriksson et al. (2006). Multi- and Megarvariate Data Analysis.
Umetrics Academy. pp.16, 77, 209.
}
\keyword{datasets}
